

Procedure MNIsNotInPattern(Text.s, Pattern.s)
  Protected s.s, z.l, n.l
  
  Text = LCase(Text)
  n = CountString(Pattern, ",")
  For z = 1 To n + 1
    s = StringField(Pattern, z, ",")
    If s <> ""
      If FindString(Text, s, 1)
        ProcedureReturn #False
      EndIf
    EndIf
  Next
  
  
  ProcedureReturn #True
EndProcedure

Procedure.l MNGetIcon(FileName.s)
  Protected ExeName.s, a.l, hIcon.l
  
  ExeName = FileName
  a       = 0
  hIcon   = ExtractAssociatedIcon_(0, @ExeName, @a)
  If a
    hIcon = a
  EndIf
  
  ProcedureReturn hIcon
EndProcedure

Procedure MNUpdate()
  Protected Typ.l, EntryName.s, FileCount.l, ItemNr.l, z.l, s.s, n.l, FileCount2.l, Name.s
  
  ClearGadgetItemList(GLOB\GUI\GTree\ID)
  TreeView_SetLineColor(GadgetID(GLOB\GUI\GTree\ID), $FF)
  TreeView_SetBkColor(GadgetID(GLOB\GUI\GTree\ID), $FFF8F0)
  
  If ExamineDirectory(0, GLOB\MN\ProjectsDir, "*.*")
    Typ = NextDirectoryEntry()
    While Typ
      If Typ = 2
        ; Ist ein Ordner
        EntryName = DirectoryEntryName()
        If EntryName <> "." And EntryName <> ".." And (GLOB\MN\UsePatterns = #False Or MNIsNotInPattern(EntryName, GLOB\MN\DontShowPrjPattern))
          
          
          Name = GLOB\MN\ProjectsDir + EntryName
          AddGadgetItem(GLOB\GUI\GTree\ID, -1, EntryName, MNGetIcon(Name))
          OpenTreeGadgetNode(GLOB\GUI\GTree\ID) ;>
            
            FileCount = 0
            n = CountString(GLOB\MN\FilePatterns, "|") + 1
            For z = 1 To n
              s = StringField(GLOB\MN\FilePatterns, z, "|")
              
              ;>
                FileCount2 = 0
                If ExamineDirectory(1, GLOB\MN\ProjectsDir + EntryName, s)
                  While NextDirectoryEntry()
                    If GLOB\MN\UsePatterns = #False Or MNIsNotInPattern(DirectoryEntryName(), GLOB\MN\DontShowFilePattern)
                      Name = GLOB\MN\ProjectsDir + EntryName + "\" + DirectoryEntryName()
                      
                      If FileCount2 = 0
                        ; setze *.txt - Icon
                        AddGadgetItem(GLOB\GUI\GTree\ID, -1, s, MNGetIcon(Name))
                        OpenTreeGadgetNode(GLOB\GUI\GTree\ID) 
                      EndIf
                      
                      AddGadgetItem(GLOB\GUI\GTree\ID, -1, DirectoryEntryName(), MNGetIcon(Name))
                      
                      FileCount + 1
                      FileCount2 + 1
                    EndIf
                  Wend
                EndIf
              
                If FileCount2 > 0
                  CloseTreeGadgetNode(GLOB\GUI\GTree\ID)
                EndIf
                
              ;<
            Next
            
            
          CloseTreeGadgetNode(GLOB\GUI\GTree\ID) ;<
          If FileCount = 0 And GLOB\MN\ShowOnlyWithFiles
            RemoveGadgetItem(GLOB\GUI\GTree\ID, CountGadgetItems(GLOB\GUI\GTree\ID) - 1)
          EndIf
          
        EndIf
        
      EndIf
      While WindowEvent() : Wend
      UseDirectory(0)
      
      Typ = NextDirectoryEntry()
    Wend
  EndIf
EndProcedure

Procedure MNSearch(In.s, With.s)
  Protected n.l, z.l
  
  With = Trim(With)
  n = CountString(With, " ") + 1
  For z = 1 To n
    If FindString(In, StringField(With, z, " "), 1) = #False
      ProcedureReturn #False
    EndIf
  Next
  
  ProcedureReturn #True
EndProcedure

Procedure MNSearchFor(Text.s)
  Protected AnzItems.l, z.l
  
  AnzItems = CountGadgetItems(GLOB\GUI\GTree\ID)
  For z = 0 To AnzItems - 1
    SetGadgetItemState(GLOB\GUI\GTree\ID, z, #PB_Tree_Collapsed)
    If Text <> ""
      If MNSearch(LCase(GetGadgetItemText(GLOB\GUI\GTree\ID, z, 0)), Text)
        SetGadgetItemState(GLOB\GUI\GTree\ID, EVTreeGetParent(EVTreeGetParent(z)), #PB_Tree_Expanded)
        SetGadgetItemState(GLOB\GUI\GTree\ID, EVTreeGetParent(z), #PB_Tree_Expanded)
        SetGadgetItemState(GLOB\GUI\GTree\ID, z, #PB_Tree_Expanded)
      EndIf
    EndIf
  Next
  
EndProcedure


 
; jaPBe Version=2.5.4.22
; FoldLines=000200120014001F00670073
; Build=0
; CompileThis=Project-Manager.pb
; FirstLine=28
; CursorPosition=95
; ExecutableFormat=Windows
; DontSaveDeclare
; EOF